﻿//////////////////////////////////////////////
// TestFunctionObserverInformation.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkDebug
{
	class TestRunResult ;
}

/// Includes ---------------------------------

// nkDebug
#include "../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Structure --------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT TestFunctionObserverInformation final
	{
		public :

			// Constructor, destructor
			TestFunctionObserverInformation () noexcept ;

			// Getters
			nkMemory::StringView getName () const ;
			unsigned long long getTimeMicroS () const ;
			TestRunResult* getRunResult () const ;

			// Setters
			void setName (nkMemory::StringView value) ;
			void setTimeMicroS (unsigned long long value) ;
			void setRunResult (TestRunResult* value) ;

		private :

			// Attributes
			// At all times
			// Always available
			nkMemory::String _name ;

			// After run
			unsigned long long _timeMicroS ;
			TestRunResult* _runResult ;
	} ;
}